<#ibiztemplate>
TARGET=PSAPPVIEWCTRL_FORM
</#ibiztemplate>
package ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.vo;

import java.sql.Timestamp;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonProperty.Access;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Data;
import org.springframework.util.StringUtils;
import ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.domain.${de.codeName};
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Map;
import java.util.Date;
import org.springframework.cglib.beans.BeanCopier;
import javax.validation.constraints.Size;
import java.util.UUID;
import org.springframework.cglib.beans.BeanCopier;
import com.fasterxml.jackson.annotation.JsonIgnore;
import ${pub.getPKGCodeName()}.ibizutil.security.AuthenticationUser;
import java.math.BigInteger;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.util.HashSet;
import java.util.Set;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class ${de.codeName}_EditForm_${ctrl.codeName}{

    @JsonProperty(access=Access.WRITE_ONLY)
    private Map<String,String> srfparentdata;
<#comment>输出属性项[多个表单项使用同一个属性，属性只输出一次]</#comment>
<#assign defieldList =''/>
<#list ctrl.getPSDEFormItems() as formitem>
    <#comment>表单项有属性，走getSet方法输出vo变量值；表单项无属性（自定义表单项），走vo属性值输出vo变量值）</#comment>
    <#if formitem.getPSDEField()??>
        <#assign defield=formitem.getPSDEField()>
        <#if defieldList?contains("["+defield.codeName+"]")>
        <#else>
    @JsonIgnore
    private ${srfjavatype(defield.stdDataType)} ${defield.codeName?lower_case};
            <#assign defieldList += "["+defield.codeName+"]">
        </#if>
    <#else>
    <#comment>自定义表单项、系统预置属性</#comment>
        <#if formitem.name?lower_case='srfsourcekey'||formitem.name?lower_case='srforikey'>
    @JsonProperty(access=Access.WRITE_ONLY)
    private ${srfjavatype(de.getKeyPSDEField().stdDataType)} ${formitem.name?lower_case};
        <#elseif formitem.name?lower_case='srftempmode'>
    @JsonIgnore
    private String srftempmode;
        <#else>
    @JsonProperty
    private String ${formitem.name?lower_case};
        </#if>
    </#if>
</#list>
<#assign isOutputCreateMethod=false>
<#assign isOutputUpdateMethod=false>
<#comment>输出表单项</#comment>
<#list ctrl.getPSDEFormItems() as formitem>
    <#comment>输出空值校验注解</#comment>
    <#if !formitem.isAllowEmpty() && (!formitem.getPSDEFDGroupLogics()??)>
        <#if formitem.getPSDEField()??>
            <#if srfjavatype(formitem.getPSDEField().stdDataType)=='String'>
    @NotBlank(message = "[${formitem.getCaption()?lower_case}]不允许为空!")
            <#else>
    @NotNull(message = "[${formitem.getCaption()?lower_case}]不允许为空!")
            </#if>
        <#else>
    @NotBlank(message = "[${formitem.getCaption()?lower_case}]不允许为空!")
        </#if>
    </#if>
    <#comment>输出字符串长度校验注解</#comment>
    <#if formitem.getPSDEField()??>
        <#if srfjavatype(formitem.getPSDEField().stdDataType)=='String'>
            <#if formitem.getPSDEField().getLength?? && formitem.getPSDEField().getLength()??>
            <#comment>创建人、更新人的length为-1</#comment>
            <#if formitem.getPSDEField().getLength()?c!='-1'>
    @Size(min = 0, max = ${formitem.getPSDEField().getLength()?c}, message = "[${formitem.getCaption()?lower_case}]长度必须在[${formitem.getPSDEField().getLength()?c}]以内!")
            </#if>
            </#if>
        </#if>
    </#if>
    <#comment>输出时间格式转换注解</#comment>
    <#if formitem.getPSDEField()??>
        <#assign defDataType = (formitem.getPSDEField().getDataType())!"">
        <#assign dataType="${srfdatatype(formitem.getPSDEField().getStdDataType())}"><#comment>外键值附加数据时间格式转换</#comment>
        <#assign defield=formitem.getPSDEField()>
        <#if defDataType == "DATETIME" || (defDataType=='PICKUPDATA' && dataType== "DATETIME" && defield.getValueFormat()=="%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS")>
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
        <#elseif defDataType == "DATE" || (defDataType=='PICKUPDATA' && dataType== "DATETIME" && defield.getValueFormat()=="%1$tY-%1$tm-%1$td")>
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
        <#elseif defDataType == "TIME" || (defDataType=='PICKUPDATA' && dataType== "DATETIME" && defield.getValueFormat()=="%1$tH:%1$tM:%1$tS")>
    @JsonFormat(pattern="HH:mm", locale = "zh" , timezone="GMT+8")
        </#if>
    </#if>
    <#comment>输出表单项get、set方法</#comment>
    <#if   formitem.name!='srfuf' && formitem.name!='srfsourcekey'>
    <#if formitem.getPSDEField()??>
    <#assign defield=formitem.getPSDEField()>
    @JsonProperty(value = "${formitem.name?lower_case}")
    public ${srfjavatype(defield.stdDataType)} get${formitem.name?lower_case?cap_first}(){
        <#comment>输出获取外键值方法-用于通过parentdata关系填充外键值id</#comment>
        <#if formitem.getPSDEField?? && formitem.getPSDEField()??>
            <#assign defield=formitem.getPSDEField()>
            <#if defield.getDataType()=='PICKUP'>
                <#assign psder1n=defield.getPSDER1N().name>
        //输出获取外键值方法-用于通过parentdata关系填充外键值id
        if(StringUtils.isEmpty(${formitem.name?lower_case}) && this.getSrfparentdata() != null)
        {
            if(this.getSrfparentdata().containsKey("srfparentmode")&& this.getSrfparentdata().get("srfparentmode").equals("${psder1n}"))
                this.${defield.codeName?lower_case}=this.getSrfparentdata().get("srfparentkey");
        }
            </#if>
        </#if>
    <#if ( formitem.getCreateDV()?? && formitem.getCreateDV()?length gt 0) || ( formitem.getCreateDVT()?? && formitem.getCreateDVT()?length gt 0)  ||  ( formitem.getUpdateDV()?? && formitem.getUpdateDV()?length gt 0) || ( formitem.getUpdateDVT()?? && formitem.getUpdateDVT()?length gt 0) >
        if(StringUtils.isEmpty(${defield.codeName?lower_case})){
        <#comment>填充表单默认值-新建</#comment>
        <#if ( formitem.getCreateDV()?? && formitem.getCreateDV()?length gt 0) || ( formitem.getCreateDVT()?? && formitem.getCreateDVT()?length gt 0) >
        <#assign isOutputCreateMethod=true><#comment>需要更新默认值，则输出判断方法</#comment>
        if(isCreate()){
            <#if formitem.getCreateDVT()==''>
                <#if formitem.getPSDEField()?? >
                    <#if srfjavatype(formitem.getPSDEField().stdDataType)=='String'>
            this.${defield.codeName?lower_case}="${formitem.getCreateDV()}";
                    <#elseif ((formitem.getPSEditorType().getStandardPSEditorType())!"") != "DATEPICKER">
            this.${defield.codeName?lower_case}=${formitem.getCreateDV()};
                    </#if>
                <#else>
            this.${defield.codeName?lower_case}="${formitem.getCreateDV()}";
                </#if>
            <#elseif formitem.getCreateDVT()=='CURTIME'>
            this.${defield.codeName?lower_case}=new Timestamp(new Date().getTime());
            <#elseif formitem.getCreateDVT()=='SESSION'>
            this.${defield.codeName?lower_case}=AuthenticationUser.getAuthenticationUser().getSessionParams().get("${formitem.getCreateDV()?lower_case}");
            <#elseif formitem.getCreateDVT()=='OPERATOR'>
            this.${defield.codeName?lower_case}=AuthenticationUser.getAuthenticationUser().getUserid();
            <#elseif formitem.getCreateDVT()=='OPERATORNAME'>
            this.${defield.codeName?lower_case}=AuthenticationUser.getAuthenticationUser().getPersonname();
            <#elseif formitem.getCreateDVT()=='UNIQUEID'>
            this.${defield.codeName?lower_case}=UUID.randomUUID().toString();
            <#elseif formitem.getCreateDVT()=='PARAM'>
            if(StringUtils.isEmpty(${formitem.name?lower_case}) && this.getSrfparentdata() != null){
                if(this.getSrfparentdata().containsKey("${formitem.getCreateDV()?lower_case}"))
                this.${defield.codeName?lower_case}=this.getSrfparentdata().get("${formitem.getCreateDV()?lower_case}");
            }
            <#else>
                // DefaultValue(value=${formitem.getCreateDV()},type=${formitem.getCreateDVT()})  暂未支持从[${formitem.getCreateDVT()}]中取值
            </#if>
        }
        </#if>
        <#comment>填充表单默认值-编辑</#comment>
        <#if (formitem.getUpdateDV()?? && formitem.getUpdateDV()?length gt 0) || ( formitem.getUpdateDVT()?? && formitem.getUpdateDVT()?length gt 0) >
        <#assign isOutputUpdateMethod=true><#comment>需要更新默认值，则输出判断方法</#comment>
        if(isUpdate()){
            <#if formitem.getUpdateDVT()==''>
                <#if formitem.getPSDEField()?? >
                    <#if srfjavatype(formitem.getPSDEField().stdDataType)=='String'>
            this.${defield.codeName?lower_case}="${formitem.getUpdateDV()}";
                    <#elseif ((formitem.getPSEditorType().getStandardPSEditorType())!"") != "DATEPICKER">
            this.${defield.codeName?lower_case}=${formitem.getUpdateDV()};
                    </#if>
                <#else>
            this.${defield.codeName?lower_case}="${formitem.getUpdateDV()}";
                </#if>
            <#elseif formitem.getUpdateDVT()=='CURTIME'>
            this.${defield.codeName?lower_case}=new Timestamp(new Date().getTime());
            <#elseif formitem.getUpdateDVT()=='SESSION'>
            this.${defield.codeName?lower_case}=AuthenticationUser.getAuthenticationUser().getSessionParams().get("${formitem.getUpdateDV()?lower_case}");
            <#elseif formitem.getUpdateDVT()=='OPERATOR'>
            this.${defield.codeName?lower_case}=AuthenticationUser.getAuthenticationUser().getUserid();
            <#elseif formitem.getUpdateDVT()=='OPERATORNAME'>
            this.${defield.codeName?lower_case}=AuthenticationUser.getAuthenticationUser().getPersonname();
            <#elseif formitem.getUpdateDVT()=='UNIQUEID'>
            this.${defield.codeName?lower_case}=UUID.randomUUID().toString();
            <#elseif formitem.getUpdateDVT()=='PARAM'>
            if(StringUtils.isEmpty(${formitem.name?lower_case}) && this.getSrfparentdata() != null){
                if(this.getSrfparentdata().containsKey("${formitem.getUpdateDV()?lower_case}"))
                this.${defield.codeName?lower_case}=this.getSrfparentdata().get("${formitem.getUpdateDV()?lower_case}");
            }
            <#else>
                //DefaultValue(value=${formitem.getUpdateDV()},type=${formitem.getUpdateDVT()})  暂未支持从[${formitem.getUpdateDVT()}]中取值
            </#if>
        }
        </#if>
        }
    </#if>
        return ${defield.codeName?lower_case};
    }
    <#comment>srfmajortext不发set方法，防止前端不给值而导致字段值被冲掉</#comment>
    <#if formitem.getName()?lower_case!='srfmajortext'>
    @JsonProperty(value = "${formitem.name?lower_case}")
        <#comment>输出时间格式转换注解</#comment>
        <#if formitem.getPSDEField()??>
            <#assign defDataType = (formitem.getPSDEField().getDataType())!"">
            <#assign dataType="${srfdatatype(formitem.getPSDEField().getStdDataType())}"><#comment>外键值附加数据时间格式转换</#comment>
            <#assign defield=formitem.getPSDEField()>
            <#if defDataType == "DATETIME" || (defDataType=='PICKUPDATA' && dataType== "DATETIME" && defield.getValueFormat()=="%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS")>
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
            <#elseif defDataType == "DATE" || (defDataType=='PICKUPDATA' && dataType== "DATETIME" && defield.getValueFormat()=="%1$tY-%1$tm-%1$td")>
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
            <#elseif defDataType == "TIME" || (defDataType=='PICKUPDATA' && dataType== "DATETIME" && defield.getValueFormat()=="%1$tH:%1$tM:%1$tS")>
    @JsonFormat(pattern="HH:mm", locale = "zh" , timezone="GMT+8")
            </#if>
        </#if>
    public void set${formitem.name?lower_case?cap_first}(${srfjavatype(defield.stdDataType)} ${defield.codeName?lower_case}){
        this.${defield.codeName?lower_case} = ${defield.codeName?lower_case};
    }
    </#if>
    </#if>
    </#if>
</#list>
    public  void from${de.codeName}(${de.codeName} sourceEntity)  {
        this.from${de.codeName}(sourceEntity,true);
    }
    <#comment>将do转换成vo，getdraft.新建时：[reset=true]默认填充所有值；拷贝时：[reset=false]判断do有值才填充，防止vo值被do中的空值冲掉</#comment>
     /**
	 * do转换为vo
	 * @param sourceEntity do数据对象
	 * @return
	 */
    public  void from${de.codeName}(${de.codeName} sourceEntity,boolean reset)  {
      BeanCopier copier=BeanCopier.create(${de.codeName}.class, ${de.codeName}_EditForm_${ctrl.codeName}.class, false);
      copier.copy(sourceEntity,this,  null);
      this.toString();
	}
    /**
	 * vo转换为do
	 * @param
	 * @return
	 */
    public  ${de.codeName} to${de.codeName}()  {
        ${de.codeName} targetEntity =new ${de.codeName}();
        BeanCopier copier=BeanCopier.create(${de.codeName}_EditForm_${ctrl.codeName}.class, ${de.codeName}.class, false);
        copier.copy(this, targetEntity, null);
        return targetEntity;
	}
    <#if isOutputCreateMethod==true>
    /**
	 * 新建
	 * @param
	 * @return
	 */
    private boolean isCreate()
    {
    	if((StringUtils.isEmpty(this.srfuf))||this.srfuf.equals("0"))
	    	return true;
    	else
    	    return false;
    }
    </#if>
    <#if isOutputUpdateMethod==true>
    /**
	 * 更新
	 * @param
	 * @return
	 */
    private boolean isUpdate()
    {
    	if((!StringUtils.isEmpty(this.srfuf))&&this.srfuf.equals("1"))
	    	return true;
    	else
    	    return false;
    }
    </#if>
    <#if ctrl.getPSDEFormItemUpdates?? && ctrl.getPSDEFormItemUpdates()??>
    <#list ctrl.getPSDEFormItemUpdates() as formItemUpdate>
        <#if !P.exists(ctrl.getCodeName(),'DynamicInclude')>
    /**
     * 使用@JsonFilter输出表单项更新中配置的表单项
     * 过滤掉Vo中其余无效表单项
     */
    private static final String DYNC_INCLUDE = "DYNC_INCLUDE";
    @JsonFilter(DYNC_INCLUDE)
    interface DynamicInclude{}
        </#if>
        <#if !P.exists(ctrl.codeName,"DEFormItemUpdates",formItemUpdate.getCodeName())>
    /**
     * 表单项更新过滤器 [${formItemUpdate.getCodeName()}]
     * 只输出表单项更新的明细项
     * @return
     */
    public JSONObject ${formItemUpdate.getCodeName()?lower_case}FormItemUpdateFilter() throws JsonProcessingException{
        JSONObject formItemDetailObj =new JSONObject();
        ObjectMapper mapper = new ObjectMapper();
        Set<String> properties =new HashSet<>();
            <#list formItemUpdate.getPSDEFIUpdateDetails() as formItemDetail>
		properties.add("${formItemDetail.getName()?lower_case}");
            </#list>
        mapper.setFilterProvider(new SimpleFilterProvider().addFilter(DYNC_INCLUDE, SimpleBeanPropertyFilter.filterOutAllExcept(properties)));
        mapper.addMixIn(this.getClass(), DynamicInclude.class);
        String strResult=mapper.writeValueAsString(this);
        if(!StringUtils.isEmpty(strResult)){
            formItemDetailObj=JSONObject.parseObject(strResult);
        }
        return formItemDetailObj;
    }
        </#if>
    </#list>
</#if>
}
